# Reconstruct HadCRUT4 from land/ocean
# Usage:
#  python blend.py hadlnd.txt hadsst.txt > hadblend.temp


import sys, math, numpy


masktxt = [
'                                                                        ',
'                cptyFIxvAAEJNMFwsd     beb   cdifa aa gh                ',
'           doslpqAGNviwKV######Sg     ksjb   aafjf abclwIvm    gjda     ',
'd  cjgca abBBGDlvwDMEqc gT####Tya a    adib   npalwvHUYWVTOKIEorHxliaaab',
'DpiOY#YXRRTLLNNKKRCvlIIm BY#Rwmjmc    mPSWMytCKLUSLWYXYY#Y#YU#YYYYVVUUXT',
'adeKYWSWXXYWPMTPOxhksCwb gOFa  flbaaaDUIFOPPYYY#YWXXX##Y##YXYWYY##YJPUMr',
'  agvkaanOYYXWRQRElbvTKDa  a      gt tErySYXXYYY#WYXYY#YWY##Y#YMkfgAAaa ',
'  ca     dLYYYXUMTWMMVSSC        awJrMRTXY#YYXY#Y##XYYW#XR###X#Rr  wcaa ',
'          dPX#YXYTDPWVQoqh         uY#WY#YNQXTQWV#WWWYXY###XXYYMkaa     ',
'           RYW##XXQOTMgc          CMFqwFVGrrSGFUV#YW#Y#Y####WWudtb      ',
'           yYYY#YY#YQb            CHrwidpxLVYTB#####YXYYX#YQhCdtk       ',
'           axTY#YXVRh             LY#YGkynnWYXY#YYYYYXX###YWieod        ',
'            axVYHebsa           bCY#######RR#QAOUXYYYYXYYY#Wia          ',
'    b        dmYybiila          mY########YyY#TJ iOYYNNYYPFkfa          ',
'    b         atKHxbcle        an##X######YLF#Oj  r#DagQYxbam           ',
'                 eyoaoid       alX##Y#UY##YYKwf   bUb bnFM bqc  a       ',
'                  alyWXUrd       vXXMY####YY#Tc    hj aikcajkha     a   ',
'                    IYY##Ra       ca h#XY#WXUm         sCeGEfd          ',
'                 b g##YXWXOxg        eUYYWNWj          bHjHtogqBrac     ',
'     a             cSY#XYYXYW         v##VVS            alnfidcmLwdda   ',
' a   a              sYY####Xu         s##YUXfja            aagFhoba ba  ',
'a     a             atWYYYYYg         E##XYDhQaa           awY#MSk   c d',
'                     d##YXTx          i###XcmE a          hS#####Vh ac  ',
'                     kYY#Yl           aR##x ab            h#######H     ',
'                     qYXVy             rQEb               aRMvuS##v   a ',
'                     F#Ut        a                         a   eHGa   fo',
'                     JXh                                        ao   fre',
'                    cRF                    a     b                   jb ',
'                    aHpac   b                                           ',
'                     ac       a                                         ',
'                       fh                              a                ',
'                    agtUb          ca cc bheqANGxuilFLHTTINFKHMKFvpha   ',
'        cfknkhhqDwtswSYU       gwITWYXYYXY#Y########################UBb ',
'ommrBDLSY#####YY#######YOEvtqANY####################################Oxxs',
'########################################################################',
'########################################################################',
]


# read a month of map data
def read_map( lines ):
  w = lines[0].split()
  month,year = sorted( [int(w[0]),int(w[1])] )
  date = year+month/12.0-1.0/24.0
  smap = [[numpy.nan for i in range(72)] for j in range(36)]
  for j in range(len(smap)):
    w = lines[j+1].split()
    for i in range(len(smap[j])):
      if not '.' in w[i]:
        t = 0.01*float(w[i])
      else:
        t = float( w[i] )
      if t > -99.0:
        smap[j][i] = t
  smap.reverse()
  return year, month, smap


# write a month of map data
def write_map( year, month, smap ):
  tmap = reversed( smap )
  lines = ["%4d %2d\n"%(year,month)]
  for row in tmap:
    s = ""
    for val in row:
      if not numpy.isnan(val):
        s += "%7.3f "%(val)
      else:
        s += "-99.9 "
    lines.append( s[:-1] + "\n" )
  return lines


# MAIN PROGRAM
# default values
datafile1 = None
datafile2 = None
if len(sys.argv) > 1:
  datafile1 = sys.argv[1]
if len(sys.argv) > 2:
  datafile2 = sys.argv[2]

# construct land mask from the ascii data
wgtmap = [ [ None for j in range(72) ] for i in range(36) ]
maskcode = " abcdefghijklmnopqrstuvwxyABCDEFGHIJKLMNOPQRSTUVWXY#"
for j in range(len(wgtmap)):
  for i in range(len(wgtmap[j])):
    w = (maskcode.index(masktxt[35-j][i])-0.5)/50.0
    wgtmap[j][i] = min( max( w, 0.0 ), 1.0 )

# read data
nmonths = 9999
f = open( datafile1 )
lines1 = f.readlines()
f.close()
nmonths = min(nmonths,len(lines1)/37)
f = open( datafile2 )
lines2 = f.readlines()
f.close()
nmonths = min(nmonths,len(lines2)/37)

# calculate temperatures
results = []
for m in range(0,nmonths):
  # extract data
  year1, month1, tmap1 = read_map( lines1[37*m:37*m+37] )
  year2, month2, tmap2 = read_map( lines2[37*m:37*m+37] )
  # check dates
  if 12*year1+month1 != 12*year2+month2: raise Exception( "Mismatched land and ocean files" )
  # calculate masked temps to fit
  tmap = [[numpy.nan for i in range(72)] for j in range(36)]
  for i in range(len(tmap2)):
    for j in range(len(tmap2[i])):
      if not numpy.isnan(tmap1[i][j]) and not numpy.isnan(tmap2[i][j]):
        wl = wgtmap[i][j]
        wo = 1.0-wl
        tmap[i][j] = wl*tmap1[i][j] +  wo*tmap2[i][j]
      elif not numpy.isnan(tmap1[i][j]):
        tmap[i][j] = tmap1[i][j]
      elif not numpy.isnan(tmap2[i][j]):
        tmap[i][j] = tmap2[i][j]
  # write map
  for l in write_map( year1, month1, tmap ): print l,

