/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

/**
	Global and package-related compiler directives for debugging purposes.
	@author Alet Roux <alet.roux@york.ac.uk>
*/

/// Use <assert.h> to enforce sensible input values.
#define USE_ASSERT
#ifdef USE_ASSERT
    #include <assert.h>
#endif

/// Print debug information in untangle_restriction().
#define VERBOSE_UNTANGLE_RESTRICTION
#ifdef VERBOSE_UNTANGLE_RESTRICTION
    #include <iostream>
#endif

///Prints debug information in PiecewiseLinear::check().
#define VERBOSE_PIECEWISELINEAR_CHECK

///Prints debug information in PiecewiseLinear::restrict_slope().
#define VERBOSE_PIECEWISELINEAR_RESTRICT_SLOPE

///Prints debug information in maximum().
#define VERBOSE_PIECEWISELINEAR_MAXIMUM

///Prints debug information in crossing().
#define VERBOSE_PIECEWISELINEAR_CROSSING

///Prints debug information in untangle_maximum().
#define VERBOSE_PIECEWISELINEAR_UNTANGLE_MAXIMUM

///Prints debug information in FlexibleTree::EMM_exercise_function().
#define VERBOSE_FLEXIBLETREE_EMM_EXERCISE_FUNCTION
#ifdef VERBOSE_FLEXIBLETREE_EMM_EXERCISE_FUNCTION
    #include <iostream>
#endif

///Prints debug information in FlexibleTree::hedging_function().
#define VERBOSE_FLEXIBLETREE_HEDGING_FUNCTION
#ifdef VERBOSE_FLEXIBLETREE_HEDGING_FUNCTION
#define VERBOSE_UNTANGLE_RESTRICTION
#endif

///Prints debug information in FlexibleTree::exercise_function().
#define VERBOSE_FLEXIBLETREE_EXERCISE_FUNCTION
#ifdef VERBOSE_FLEXIBLETREE_EXERCISE_FUNCTION
    #include <iostream>
    #define VERBOSE_TREEPRODUCT_AMERICANBUYER_EXERCISE
#endif

///Prints debug information in FlexibleTree::pricing_function().
#define VERBOSE_FLEXIBLETREE_PRICING_FUNCTION
#ifdef VERBOSE_FLEXIBLETREE_PRICING_FUNCTION
    #include <iostream>
#endif

///Prints debug information in TreeProductAmericanBuyerOptional::exercise().
#define VERBOSE_TREEPRODUCT_AMERICANBUYER_EXERCISE
