/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef EXISTINGRESULTS_H
#define EXISTINGRESULTS_H

/**
 \file
 Functions that reproduce numerical results in models that have been studied in the literature.

 */

///Boyle, P.P., Vorst, T., Option Replication in Discrete Time with Transaction Costs, The Journal of Finance, 1992, XLVII, 347-382
void BoyleVorst1992();

///Edirisinghe, C.; Naik, V. & Uppal, R. Optimal Replication of Options with Transactions Costs and Trading Restrictions The Journal of Financial and Quantitative Analysis, 1993, 28, 117-138.
void EdirsingheNaikUppal1993();

///Palmer, K., A note on the Boyle-Vorst discrete-time option pricing model with transactions costs, Mathematical Finance, 2001, 11, 357-363.
void Palmer2001();

///Perrakis, S. & Lefoll, J. The American put under transactions costs Journal of Economic Dynamics and Control, 2004, 28, 915-935.
void PerrakisLefoll2004();

///Tokarz, K. & Zastawniak, T. American contingent claims under small proportional transaction costs Journal of Mathematical Economics, 2006, 43, 65-85.
void TokarzZastawniak2006();

///Roux, A. Options under transaction costs: Algorithms for pricing and hedging of European and American options under proportional transaction costs and different borrowing and lending rates VDM Verlag, 2008.
void Roux2008();

///Roux, A.; Tokarz, K. & Zastawniak, T. Options under Proportional Transaction Costs: An Algorithmic Approach to Pricing and Hedging Acta Applicandae Mathematicae, 2008, 103, 201-219.
void RouxTokarzZastawniak2008();

///Roux, A. & Zastawniak, T. American Options under Proportional Transaction Costs: Pricing, Hedging and Stopping Algorithms for Long and Short Positions Acta Applicandae Mathematicae, 2009, 106, 199-228.
void RouxZastawniak2009();

///Lohne, A. & Rudloff, B. An algorithm for calculating the set of superhedging portfolios and strategies in markets with transaction costs 2011.
void LohneRudloff2011();

///Catch-all function that compares with all known results.
void existingresults();

#endif
