/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PARAMETERBRIDGE_H
#define PARAMETERBRIDGE_H

#include "parameter.h"

/**
 \file
#ParameterBridge
 */

///Wrapper class for #Parameter.
/**
  Takes care of #Parameter memory management
 @author Alet Roux <alet.roux@york.ac.uk>
*/
class ParameterBridge
{
public:
	ParameterBridge (const ParameterBridge& original)
	{
		_parameter = original._parameter->clone();
	}

	ParameterBridge (const Parameter& parameter)
	{
		_parameter = parameter.clone();
	}

	///Assignment operator
	ParameterBridge& operator= (const ParameterBridge& original)
	{
		if (this != &original)
		{
			delete _parameter;
			_parameter = original._parameter->clone();
		}

		return *this;
	}

	///Current value of parameter
	coefficient operator() (const coefficient time) const
	{
		return _parameter->operator() (time);
	}

	~ParameterBridge()
	{
		delete _parameter;
	}

private:
	Parameter* _parameter;
};

#endif // PARAMETERBRIDGE_H
