/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PARAMETERCONSTANTZEROINITIAL_H
#define PARAMETERCONSTANTZEROINITIAL_H

#include "constant.h"

///Parameter with value 0 at time 0, and fixed value at all other times
class ParameterConstantZeroInitial : public ParameterConstant
{
public:
	ParameterConstantZeroInitial (const coefficient value);

	virtual coefficient operator()(const coefficient time) const;
	virtual ParameterConstantZeroInitial* clone() const;
};

#endif // PARAMETERCONSTANTZEROINITIAL_H
