/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "constantzeroinitialfinal.h"

#include "../config.h"

ParameterConstantZeroInitialFinal::ParameterConstantZeroInitialFinal (const coefficient value, const coefficient time)
: ParameterConstant (value), _time (time)
{
#ifdef USE_ASSERT
	assert (time > 0);
#endif
}

coefficient ParameterConstantZeroInitialFinal::operator()(const coefficient time) const
{
	if (greaterthan(time,0.0) && lessthan(time,_time))
		return value();
	return 0.0;
}

ParameterConstantZeroInitialFinal* ParameterConstantZeroInitialFinal::clone() const
{
	return new ParameterConstantZeroInitialFinal(*this);
}

