/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PARAMETERINTEGRABLE_H
#define PARAMETERINTEGRABLE_H

#include "parameter.h"

///Parameter that is integrable over time.
/**
	 Inspired by the ParametersInner class in Mark Joshi "Design Patterns and Derivatives Pricing", Cambridge University Press, 2004.
	@author Alet Roux <alet.roux@york.ac.uk>
*/
class ParameterIntegrable : public Parameter
{
public:
	virtual ParameterIntegrable* clone() const = 0;

	///Integral of parameter from \a time1 to \a time2
   	virtual coefficient integral (const coefficient time1, const coefficient time2) const = 0;

	///Integral of squared parameter from \a time1 to \a time2
   	virtual coefficient integral_square (const coefficient time1, const coefficient time2) const = 0;

	///Square root of integral of squared parameter over [\a time1, \a time2]
   	virtual coefficient root_integral_square (const coefficient time1, const coefficient time2) const = 0;
};

#endif // PARAMETERINTEGRABLE_H
