/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "integrableconstant.h"

ParameterIntegrableConstant::ParameterIntegrableConstant (const coefficient value)
: _value (value), _squared (value*value)
{}

coefficient ParameterIntegrableConstant::operator()(const coefficient time) const
{
	return _value;
}

ParameterIntegrableConstant* ParameterIntegrableConstant::clone() const
{
	return new ParameterIntegrableConstant(*this);
}

coefficient ParameterIntegrableConstant::integral (const coefficient time1, const coefficient time2) const
{
	return _value * (time2 - time1);
}

coefficient ParameterIntegrableConstant::integral_square (const coefficient time1, const coefficient time2) const
{
	return _squared * (time2 - time1);
}

coefficient ParameterIntegrableConstant::root_integral_square (const coefficient time1, const coefficient time2) const
{
	return  ((_value > 0) ? _value : -_value) * sqrtl (time2 - time1);
}
