/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/


#ifndef PARAMETERINTEGRABLECONSTANT_H
#define PARAMETERINTEGRABLECONSTANT_H

#include "integrable.h"

///Parameter with fixed value (where integrability is used).
class ParameterIntegrableConstant : public ParameterIntegrable
{
public:
	ParameterIntegrableConstant (const coefficient value);

	coefficient operator()(const coefficient time) const;
	ParameterIntegrableConstant* clone() const;

   	coefficient integral (const coefficient time1, const coefficient time2) const;
   	coefficient integral_square (const coefficient time1, const coefficient time2) const;
   	coefficient root_integral_square (const coefficient time1, const coefficient time2) const;

private:
	coefficient _value, _squared;
};

#endif // PARAMETERINTEGRABLECONSTANT_H
