/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFBASKET_H
#define PAYOFFBASKET_H

//#include "payoff.h"
//#include "bridge.h"
//#include <vector>

typedef std::vector<PayoffBridge> payoff_array;

///Basket option
class PayoffBasket : public Payoff
{
public:
	PayoffBasket (const payoff_array &payoffs)
	: _payoffs (payoffs)
	{}

	PayoffBasket (const PayoffBasket &original)
	: _payoffs (original._payoffs)
	{}

	Portfolio operator() (const Spot& spot) const
	{
		Portfolio payoff (0,0);
		for (size_t k = 0; k < _payoffs.size(); k++)
			payoff += _payoffs[k] (spot);
		return payoff;
	}

	PayoffBasket* clone() const
	{
		return new PayoffBasket (*this);
	}

protected:
	payoff_array _payoffs;
};

	///Addition operator
//	PayoffBridge& operator+(const PayoffBridge& first,const PayoffBridge& second)
//	{

//	      payoff_array payoff;
//	      payoff.push_back(first);
//	      payoff.push_back(second);
//	      return *(new PayoffBridge(PayoffBasket (payoff)));
//	}


#endif // PAYOFFBASKET_H
