/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFBEARSPREAD_H
#define PAYOFFBEARSPREAD_H

//#include "payoff.h"

///Bear spread.
/**
 The payoff consists of a short put option with strike \f$ K \f$ and a long put option with strike \f$ L \f$. Delivery of all options is simultaneous and in cash, based on the underlying stock price.
 @author Alet Roux <ar521@york.ac.uk>
 */
class PayoffBearSpread : public Payoff
{
	public:
		PayoffBearSpread (const coefficient K, const coefficient L)
	: _K (K), _L (L)
		{}

		Portfolio operator() (const Spot& spot) const
		{
			if (lessthan (spot.underlying(),_K))
				return Portfolio (0, _L - _K);

			if (lessthan (_L, spot.underlying()))
				return Portfolio (0, 0);

			return Portfolio (0, _L - spot.underlying());
		}

		PayoffBearSpread* clone() const
		{
			return new PayoffBearSpread (*this);
		}

	private:
		coefficient _K, _L;
};

#endif // PAYOFFBEARSPREAD_H
