/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFBRIDGE_H
#define PAYOFFBRIDGE_H

////#include "../numbers.h"
////#include "../spot.h"
#include "payoff.h"

#include "neg.h"

class PayoffBasket;


/**
 \file
#PayoffBridge
 */

///Wrapper for #Payoff.
/**
 Takes care of #Payoff memory management. Based on the PayoffBridge class in Joshi, M. "Design Patterns and Derivatives Pricing", Cambridge University Press, 2004.
 @author Alet Roux <alet.roux@york.ac.uk>
*/
class PayoffBridge
{
public:
	PayoffBridge (const PayoffBridge& original) { _payoff = original._payoff->clone(); }

	PayoffBridge (const Payoff& payoff) { _payoff = payoff.clone(); }

	///Payoff for given \a spot
	Portfolio operator() (const Spot& spot) const { return _payoff->operator() (spot); }

	///Assignment operator
	PayoffBridge& operator= (const PayoffBridge& original)
	{
		if (this != &original)
		{
			delete _payoff;
			_payoff = original._payoff->clone();
		}

		return *this;
	}

	///Negation operator
	PayoffBridge& operator-() const
	{
		return *(new PayoffBridge(PayoffNeg (*_payoff)));
	}

	~PayoffBridge() { delete _payoff; }

protected:

	Payoff* _payoff;
};

#endif // PAYOFFBRIDGE_H
