/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFBULLSPREAD_H
#define PAYOFFBULLSPREAD_H

//#include "payoff.h"

///Bull spread.
/**
 Payoff consists of a long call option with strike \f$ K \f$ and a short call option with strike \f$ L \f$. Delivery of all options is simultaneous and in cash, based on the underlying stock price.
 @author Alet Roux <alet.roux@york.ac.uk>
 */
class PayoffBullSpread : public Payoff
{
public:
	PayoffBullSpread (const coefficient K, const coefficient L)
			: _K (K), _L (L)
	{}

	Portfolio operator() (const Spot& spot) const
	{
		if (lessthan (spot.underlying(),_K))
			return Portfolio (0,0);

		if (lessthan (_L, spot.underlying()))
			return Portfolio (0, _L - _K);

		return Portfolio (0, spot.underlying() - _K);
	}

	PayoffBullSpread* clone() const
	{
		return new PayoffBullSpread (*this);
	}

private:
	coefficient _K, _L;
};

#endif // PAYOFFBULLSPREAD_H
