/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFBUTTERFLY_H
#define PAYOFFBUTTERFLY_H

//#include "payoff.h"

///Butterfly spread.
/**
 Payoff consists of a long call option with strike \f$ K-d \f$, a long call option with strike \f$ K+d \f$ and two short call options with strike \f$ K \f$. Delivery of all options is simultaneous and in cash, based on the underlying stock price.
 @author Alet Roux <alet.roux@york.ac.uk>
 */
class PayoffButterfly : public Payoff
{
public:
	PayoffButterfly (const coefficient K, const coefficient d)
			: _K (K), _d (d)
	{}

	Portfolio operator() (const Spot& spot) const
	{
		if (greaterthan (spot.underlying(),_K+_d) || lessthan (spot.underlying(),_K-_d))
			return Portfolio (0,0);

		if (greaterthan (_K, spot.underlying()))
			return Portfolio (0, spot.underlying() - _K + _d);

		return Portfolio (0, _K + _d - spot.underlying());
	}

	PayoffButterfly* clone() const
	{
		return new PayoffButterfly (*this);
	}

private:
	coefficient _K, _d;
};

#endif // PAYOFFBUTTERFLY_H
