/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFCALLPHYSICALASK_H
#define PAYOFFCALLPHYSICALASK_H

////#include <ostream>

#include "singlestrike.h"

/// Call option with physical delivery based on ask price (deprecated).
/**
 Pays a share and -strike() in cash, provided that ask price of share is bigger than strike().
 @author Alet Roux <alet.roux@york.ac.uk>
 */
class PayoffCallPhysicalAsk : public PayoffSingleStrike
{
public:
	PayoffCallPhysicalAsk (const coefficient strike)
			: PayoffSingleStrike (strike)
	{}

	Portfolio operator() (const Spot& spot) const
	{
		coefficient payoff = spot.ask()-strike();
		return greaterthan (payoff, 0.0) ? Portfolio (1,-strike()) : Portfolio (0,0);
	}

	PayoffCallPhysicalAsk* clone() const
	{
		return new PayoffCallPhysicalAsk (*this);
	}
};

std::ostream& operator<< (std::ostream& output, const PayoffCallPhysicalAsk& call);

#endif // PAYOFFCALLPHYSICALASK_H
