/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFCALLPHYSICALBID_H
#define PAYOFFCALLPHYSICALBID_H

////#include <ostream>

#include "singlestrike.h"

/// Call option with physical delivery based on bid price (deprecated).
/**
 Pays a share and -strike() in cash, provided that bid price of share is bigger than strike().
 @author Alet Roux <alet.roux@york.ac.uk>
 */
class PayoffCallPhysicalBid : public PayoffSingleStrike
{
public:
	PayoffCallPhysicalBid (const coefficient strike)
			: PayoffSingleStrike (strike)
	{}

	Portfolio operator() (const Spot& spot) const
	{
		coefficient payoff = spot.bid()-strike();
		return greaterthan (payoff, 0.0) ? Portfolio (1,-strike()) : Portfolio (0,0);
	}
	PayoffCallPhysicalBid* clone() const
	{
		return new PayoffCallPhysicalBid (*this);
	}
};

std::ostream& operator<< (std::ostream& output, const PayoffCallPhysicalBid& call);

#endif // PAYOFFCALLPHYSICALBID_H
