/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFMULTI_H
#define PAYOFFMULTI_H

//#include "payoff.h"

///Scalar multiple of #Payoff.
/**
  Inspired by the PayoffBridge class in Joshi, M. "Design Patterns and Derivatives Pricing", Cambridge University Press, 2004.
 @author Alet Roux <alet.roux@york.ac.uk>
*/
class PayoffMulti : public Payoff
{
public:
	PayoffMulti (const PayoffMulti& payoff)
	{
		_multiple = payoff._multiple;
		_payoff = payoff._payoff->clone();
	}

	PayoffMulti (const coefficient multiple, const Payoff& payoff)
			: _multiple (multiple)
	{
		_payoff = payoff.clone();
	}

	PayoffMulti (const Payoff& payoff)
			: _multiple (1.0)
	{
		_payoff = payoff.clone();
	}

	Portfolio operator() (const Spot& spot) const
	{
		return (_payoff->operator() (spot) *=_multiple);
	}

	PayoffMulti* clone() const
	{
		return new PayoffMulti (*this);
	}

	~PayoffMulti()
	{
		delete _payoff;
	}

private:
	coefficient _multiple;
	Payoff* _payoff;
};

#endif // PAYOFFMULTI_H
