/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFF_H
#define PAYOFF_H

#include "../portfolio.h"
//#include "../spot.h"

/**
 \file
#Payoff and some of its most general methods
 */

///Option payoff consisting of a portfolio of cash and shares.
/**
  Based on the Payoff class in Joshi, M. "Design Patterns and Derivatives Pricing", Cambridge University Press, 2004.
 @author Alet Roux <alet.roux@york.ac.uk>
*/
class Payoff
{
public:
	///Gives payoff of option under given spot price
	virtual Portfolio operator() (const Spot& spot) const = 0;

	///Clone constructor
	virtual Payoff* clone() const = 0;

	virtual ~Payoff() {};
};

#endif // PAYOFF_H
