/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PAYOFFPUTPHYSICALASK_H
#define PAYOFFPUTPHYSICALASK_H

////#include <ostream>

#include "singlestrike.h"

///Put option with physical delivery based on ask price (deprecated).
/**
 Pays a portfolio of strike() in cash and a short position in the stock, provided that ask price of share is less than strike().
 @author Alet Roux <alet.roux@york.ac.uk>
 */
class PayoffPutPhysicalAsk : public PayoffSingleStrike
{
public:
	PayoffPutPhysicalAsk (const coefficient strike)
	: PayoffSingleStrike(strike)
	{}

	Portfolio operator() (const Spot& spot) const
	{
		coefficient payoff = strike()-spot.ask();
		return greaterthan (payoff, 0.0) ? Portfolio (-1, strike()) : Portfolio (0, 0);
	}

	PayoffPutPhysicalAsk* clone() const
	{
		return new PayoffPutPhysicalAsk(*this);
	}

};

std::ostream& operator<< (std::ostream& output, const PayoffPutPhysicalAsk& put);

#endif // PAYOFFPUTPHYSICALASK_H
