/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef SHORTRATE_H
#define SHORTRATE_H

#include "numbers.h"

/**
 \file
#ShortRate
 */

///Abstraction of short rate for purposes of discounting.
class ShortRate
{
public:
	///Value at \a t1 of one unit at time \a t2
	virtual coefficient discount (const coefficient t1, const coefficient t2) const = 0;

	///Value at \a t2 of one unit at time \a t1
	virtual coefficient accumulate (const coefficient t1, const coefficient t2) const = 0;
};

#endif // SHORTRATE_H
