/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "spot.h"

std::ostream& operator<< (std::ostream& output, const Spot& spot)
{
	if (spot.ask() == spot.bid())
		return output << spot.ask();

	output << "[" << spot.bid();
	if (!isnan (spot.underlying()))
		output << " (" << spot.underlying() << ") ";
	else
		output << ", ";
	output << "" << spot.ask() << "]";
	return output;
}
