/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef SPOT_H
#define SPOT_H

#include <ostream>
#include "numbers.h"

/**
 \file
#Spot
 */

///Asset price with proportional transaction costs.
/**
  Asset can be bought at ask() price and sold at bid() price.
 @author Alet Roux <alet.roux@york.ac.uk>
*/
class Spot
{
public:
	Spot (const coefficient& underlying = NAN)
			: _bid (underlying), _ask (underlying), _underlying (underlying)
	{}

	Spot (const coefficient bid, const coefficient underlying, const coefficient ask)
			: _bid (bid), _ask (ask), _underlying (underlying)
	{}

	///Price at which asset may be sold
	inline coefficient bid() const;

	///Price at which asset may be bought
	inline coefficient ask() const;

	///Underlying asset price
	inline coefficient underlying() const;

private:
	coefficient _bid, _ask, _underlying;

};

coefficient Spot::bid() const
{
	return _bid;
}

coefficient Spot::ask() const
{
	return _ask;
};

coefficient Spot::underlying() const
{
	return _underlying;
};

std::ostream& operator<< (std::ostream& output, const Spot& spot);


#endif // SPOT_H
