/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef SPOTMULAMBDA_H
#define SPOTMULAMBDA_H

//#include "numbers.h"
//#include "spot.h"

///Asset price with proportional transaction costs.
/**
 If \f$ S \f$ is the underlying price, then the asset can be bought at \f$ S(1+\lambda)\f$ and sold at \f$ S(1-\mu)\f$.
 @author Alet Roux <ar521@york.ac.uk>
*/
class SpotMuLambda : public Spot
{
public:
	///Asset can be bought at \a underlying (1 + \a lambda) and sold at \a underlying (1 - \a mu).
	SpotMuLambda (coefficient underlying, coefficient mu, coefficient lambda)
			: Spot (underlying* (1-mu), underlying, underlying* (1+lambda))
	{}
};

#endif // SPOTMULAMBDA_H
