/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef STATISTICSGATHERER_FINAL_H
#define STATISTICSGATHERER_FINAL_H

//#include <vector>
//#include <ostream>

///Collects all objects of interest at final time step only (not tested).
template<class T>
class StatisticsGathererFinal : public StatisticsGatherer<T>
{
public:
	/**
	 * Constructor.
	 * @param N The final time step.
	 */
	StatisticsGathererFinal (const size_t N) : _N (N) {};

	operator T() const
	{
		return _object[0][0];
	}

	virtual void dump_result (const size_t t, const size_t k, const T& object)
	{
		if (t == _N)
		  _object[k] = object;
	}

	std::vector<T> operator[] (const size_t k) const
	{
		return _object[k];
	};

	std::vector<T>& operator[] (const size_t k)
	{
		return _object[k];
	};

	T operator() (const size_t k) const
	{
		return _object[k];
	};

	T& operator() (const size_t k)
	{
		return _object[k];
	};

	///Number of scenarios
	size_t size() const
	{
		return _object.size();
	}

private:
	size_t _N;
	std::vector<T> _object;
};

template<class T>
inline std::ostream& operator<< (std::ostream& output, const StatisticsGathererFinal<T>& function)
{
		for (size_t k = 0; k < function.size(); k++)
			output << "(" << k << "): " << function (k) << std::endl;
	return output;
}

#endif // STATISTICSGATHERER_FINAL_H
