/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef STATISTICSGATHERER_INITIAL_H
#define STATISTICSGATHERER_INITIAL_H

#include "statisticsgatherer.h"

///Collects object of interest only at root node.
/**
 Used for pricing where hedging is unimportant.
 @author Alet Roux <ar521@york.ac.uk>
*/
template<class T>
class StatisticsGathererInitial : public StatisticsGatherer<T>
{
public:
	StatisticsGathererInitial () {};

	virtual void dump_result (const size_t t, const size_t k, const T& object)
	{
		if (t == 0)
			_object = object;
	}

	operator T() const
	{
		return _object;
	}

protected:
	T _object;
};


#endif // STATISTICSGATHERER_INITIAL_H
