/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef STATISTICSGATHERER_SOME_H
#define STATISTICSGATHERER_SOME_H

////#include <vector>
////#include <ostream>

//#include "initial.h"
#include "path.h"

///Collects all objects of interest with paths moving through the specified nodes.
template<class T>
class StatisticsGathererSome : public StatisticsGatherer<T>
{
public:
	/**
	 * Constructor.
	 * @param path Information is gathered for this collection of nodes. Any element \a path[t][k] is a node at the \f$ t \f$-th time step.
	 */
	StatisticsGathererSome (const std::vector< std::vector<size_t> >& path)
			: _path (path)
	{
		for (size_t t = 0; t < _path.size(); t++)
			_object.push_back (std::vector<T> (_path[t].size()));
	}

	operator StatisticsGathererInitial<T>() const
	{
		StatisticsGathererInitial<T> gatherer;
		gatherer.dump_result (0, 0, _object[0][0]);

		return gatherer;
	}

	operator T() const
	{
		return _object[0][0];
	}

	virtual void dump_result (const size_t t, const size_t k, const T& object)
	{
		for (size_t l = 0; l < _path[t].size(); l++)
			if (_path[t][l] == k)
				_object[t][l] = object;
	}

	std::vector<T> operator[] (const size_t t) const
	{
		return _object[t];
	};

	std::vector<T>& operator[] (const size_t t)
	{
		return _object[t];
	};

	T operator() (const size_t t, const size_t k) const
	{
		return _object[t][k];
	};

	T& operator() (const size_t t, const size_t k)
	{
		return _object[t][k];
	};

	StatisticsGathererPath<T> operator() (const std::vector<size_t>& path) const
	{
		StatisticsGathererPath<T> gatherer (path);
		for (size_t t = 0; t < _path.size(); t++)
			for (size_t k = 0; k < _path[t].size(); k++)
				gatherer.dump_result (t,_path[t][k],_object[t][k]);
		return gatherer;
	};

	///Number of steps
	size_t size() const
	{
		return _object.size();
	}

	///Number of steps
	size_t size (const size_t t) const
	{
		return _object[t].size();
	}

	///Node number \a k at time step \a t.
	size_t node (const size_t t, const size_t k) const
	{
		return _path[t][k];
	};


private:
	std::vector< std::vector<size_t> > _path;
	std::vector< std::vector<T> > _object;
};

template<class T>
inline std::ostream& operator<< (std::ostream& output, const StatisticsGathererSome<T>& function)
{
	for (size_t t = 0; t < function.size(); t++)
		for (size_t k = 0; k < function.size (t); k++)
			output << "(" << t << "," << function.node (t,k) << "): " << function (t,k) << std::endl;
	return output;
}

#endif // STATISTICSGATHERER_SOME_H
