/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef STATISTICSGATHERER_H
#define STATISTICSGATHERER_H

#include <cstdlib>

///Collects statistics in the #FlexibleTree class.
/**
 Also acts as "dummy" gatherer, in case none is needed.
 @author Alet Roux <ar521@york.ac.uk>
*/
template<class T>
class StatisticsGatherer
{
public:
	StatisticsGatherer () {};

	///Collects intance of object \a T at time \a t at node \a k.
	virtual void dump_result (const size_t t, const size_t k, const T& object) {};
};

#endif // STATISTICSGATHERER_H
