/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef AMERICAN_H
#define AMERICAN_H

//#include "../piecewiselinear/piecewiselinear.h"
//#include "../spot.h"
#include "../config.h"
#include "../payoff/bridge.h"
#include "treeproduct.h"


///#TreeProduct methods for American options
class TreeProductAmerican : public TreeProduct
{
  public:
	TreeProductAmerican (const coefficient expiry, const PayoffBridge& payoff) : TreeProduct (expiry), _payoff (payoff) {};

  	/**
	 * Finds set of portfolios that hedges the option at any time \a t before expiry.
	 * @param t Current time
	 * @param spot Price of underlying asset
	 * @return Piecewise linear function that gives the lower boundary of set of hedging portfolios
	 */
    PiecewiseLinear payoff_hedge (const coefficient& t, const Spot& spot) const
    {
#ifdef USE_ASSERT
        assert (lessequal(t,expiry()) && lessequal(0,t));
#endif
        return portfolios_that_can_afford (_payoff(spot), spot);
    };

    Portfolio payoff (const coefficient& t, const Spot& spot) const
    {
 #ifdef USE_ASSERT
        assert (lessequal(t,expiry()) && lessequal(0,t));
#endif
      return _payoff(spot);
    }

private:
	PayoffBridge _payoff;
};
#endif // AMERICAN_H
