/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef TREEPRODUCT_AMERICAN_BUYERNOOPTIONAL_H
#define TREEPRODUCT_AMERICAN_BUYERNOOPTIONAL_H

#include "exercisable.h"
#include "american.h"

///Prices #TreeProductAmerican for the buyer (deprecated).
/**
    Assumes that exercise at final time takes place whenever the final payoff of the option is nonzero, so may be faster for options with cash payoff.
	@author Alet Roux <alet.roux@york.ac.uk>
*/

class TreeProductAmericanBuyer : public TreeProductAmerican, public TreeProductExercisable
{

public:
    TreeProductAmericanBuyer (const coefficient expiry, const PayoffBridge& payoff) : TreeProductAmerican(expiry,-payoff) {};

    PiecewiseLinear final_hedge (const Spot& spot) const
    {
        return payoff_hedge (expiry(),spot);
    }

    PiecewiseLinear interim_hedge (const coefficient time, const Spot& spot, const PiecewiseLinear& future_hedge) const
    {
#ifdef USE_ASSERT
        assert (time < expiry());
#endif

        PiecewiseLinear current = future_hedge;
        current.restrict_slope (-spot.ask(), -spot.bid());

        PiecewiseLinear reference = payoff_hedge (time, spot);

        return minimum (current, reference);
    }

    coefficient current_price(const PiecewiseLinear& current, const Portfolio& holdings = Portfolio (0,0)) const
    {
      return buyers_price (current, holdings);
    }

    int exercise (const coefficient t, const Spot& spot, const Portfolio& current_portfolio) const
    {
	if (t < expiry())
	{
		if (lessthan (current_portfolio.cash(), payoff_hedge (t, spot) (current_portfolio.shares())))
			return 0;

		return 1;
	}

	return 1;
    }

};


#endif // TREEPRODUCT_AMERICAN_BUYERNOOPTIONAL_H
