/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef TREEPRODUCT_AMERICAN_BUYER_H
#define TREEPRODUCT_AMERICAN_BUYER_H

//#include "americanbuyer.h"

#include "../config.h"

///Prices #TreeProductAmerican for the buyer.
/**
	Allows for possibility that option may not be exercised at all, even if payoff at final time is non-zero.
	@author Alet Roux <alet.roux@york.ac.uk>
*/

class TreeProductAmericanBuyerOptional : public TreeProductAmericanBuyer
{

public:
	TreeProductAmericanBuyerOptional (const coefficient expiry, const PayoffBridge& payoff) : TreeProductAmericanBuyer(expiry,payoff) {};

	PiecewiseLinear final_hedge (const Spot& spot) const
	{
	  PiecewiseLinear hedge = payoff_hedge (expiry(), spot);
	  include_solvent_portfolios (hedge, spot);
	  return hedge;
	}

	int exercise (const coefficient t, const Spot& spot, const Portfolio& current_portfolio) const
	{
	coefficient payoff_value = payoff_hedge (t, spot) (current_portfolio.shares());

#ifdef VERBOSE_TREEPRODUCT_AMERICANBUYER_EXERCISE
	std::cout << "Minimum cash value to allow exercise: " << payoff_value << std::endl;
#endif

	if (greaterequal (current_portfolio.cash(), payoff_value))
		return 1;

	return 0;
	}
};


#endif // TREEPRODUCT_AMERICAN_BUYER_H
