/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef TREEPRODUCT_AMERICAN_SELLERNOOPTIONAL_H
#define TREEPRODUCT_AMERICAN_SELLERNOOPTIONAL_H

#include "american.h"
#include "randomexercisable.h"

///Prices #TreeProductAmerican for the seller (deprecated).
/**
	Assumes that exercise at final time takes place whenever the final payoff of the option is nonzero, so may be faster for options with cash payoff.
	@author Alet Roux <alet.roux@york.ac.uk>
*/
class TreeProductAmericanSeller : public TreeProductAmerican, public TreeProductRandomExercisable
{

public:
	TreeProductAmericanSeller (const coefficient expiry, const PayoffBridge& payoff) : TreeProductAmerican (expiry, payoff) {};

	PiecewiseLinear final_hedge (const Spot& spot) const
	{
	  return payoff_hedge (expiry(), spot);
	}

	PiecewiseLinear interim_hedge (const coefficient time, const Spot& spot, const PiecewiseLinear& future_hedge) const
	{
#ifdef USE_ASSERT
	assert (time < expiry());
#endif

	PiecewiseLinear current = future_hedge;
	current.restrict_slope (-spot.ask(), -spot.bid());

	PiecewiseLinear reference = payoff_hedge (time, spot);
	return maximum (current, reference);
	}

	coefficient current_price(const PiecewiseLinear& current, const Portfolio& holdings = Portfolio (0,0)) const
	{
	  return sellers_price(current, holdings);
	}

   /**
	 * Value of (least) optimal randomised stopping time for the buyer at time \a t with share price \a spot for the seller. The assumptions are that it has not been fully exercised yet, the current and future hedging portfolios are bounded from below by \a current_hedge and \a future_hedge, respectively, the number \a x is in the bid-ask interval, and \a shares is the current share holding. The function returns a number \f$\chi\in[0,1]\f$, and optionally numbers \a y and \a S in the bid-ask interval such that \f$x=\chi S + (1-\chi)y\f$.
	 */
    coefficient random_exercise (const coefficient t, const Spot& spot, const PiecewiseLinear& current_hedge, const PiecewiseLinear& future_hedge, const coefficient x, coefficient& y, coefficient& S, const Portfolio& portfolio) const
    {
	if (equal (t, expiry()))
	{
		y = x;
		S = x;
		return 1.0;
	}

	std::vector<PiecewiseLinear> g;
	g.push_back (payoff_hedge (t, spot));
	g.push_back (future_hedge);
	g[1].restrict_slope (-spot.ask(), -spot.bid());

	std::vector<coefficient> p, X;

	coefficient shares = portfolio.shares();
	untangle_maximum (current_hedge, g, x, shares, p, X);

	S = X[0];
	y = X[1];

	return p[0];
   }

};

#endif // TREEPRODUCT_AMERICAN_SELLERNOOPTIONAL_H
