/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef TREEPRODUCT_AMERICAN_SELLER_H
#define TREEPRODUCT_AMERICAN_SELLER_H

//#include "americanseller.h"

///Prices #TreeProductAmerican for the seller.
/**
	Allows for possibility that option may not be exercised at all, even if payoff at final time is non-zero.
	@author Alet Roux <alet.roux@york.ac.uk>
*/

class TreeProductAmericanSellerOptional : public TreeProductAmericanSeller
{

public:
 	TreeProductAmericanSellerOptional (const coefficient expiry, const PayoffBridge& payoff) : TreeProductAmericanSeller(expiry, payoff) {};

 	PiecewiseLinear final_hedge (const Spot& spot) const
	{
	  PiecewiseLinear hedge = payoff_hedge (expiry(), spot);
	  ensure_solvent (hedge, spot);
	  return hedge;
	};

    coefficient random_exercise (const coefficient t, const Spot& spot, const PiecewiseLinear& current_hedge, const PiecewiseLinear& future_hedge, const coefficient x, coefficient& y, coefficient& S, const Portfolio& portfolio) const
    {
 	std::vector<PiecewiseLinear> g;
 	g.push_back (payoff_hedge (expiry(), spot));
 	if (equal (t,expiry()))
	g.push_back (solvency_cone (spot));
 	else
 	{
 		g.push_back (future_hedge);
 		g[1].restrict_slope (-spot.ask(), -spot.bid());
 	}

 	std::vector<coefficient> p, X;

 	coefficient shares = portfolio.shares();
 	untangle_maximum (current_hedge, g, x, shares, p, X);

 	S = X[0];
 	y = X[1];

 	return p[0];
   }

};

#endif // TREEPRODUCT_AMERICAN_SELLER_H
