/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef EUROPEAN_H
#define EUROPEAN_H

//#include "treeproduct.h"

//#include "../piecewiselinear/piecewiselinear.h"
//#include "../spot.h"
//#include "../payoff/bridge.h"

#include "../config.h"

///#TreeProduct methods for European options.
class TreeProductEuropean : public TreeProduct
{
  public:
	TreeProductEuropean (const coefficient expiry, const PayoffBridge& payoff) : TreeProduct (expiry), _payoff (payoff) {};

	/**
	 * At an interim time step, finds set of portfolios that hedges the payoff of the option in the future
	 * @param t Time
	 * @param spot Price of underlying asset
	 * @param future_hedge Piecewise linear function whose epigraph consist of portfolios that hedge the option at all future time steps
	 * @return Piecewise linear function that gives the lower boundary of set of hedging portfolios
	 */
	PiecewiseLinear interim_hedge (const coefficient t, const Spot& spot, const PiecewiseLinear& future_hedge) const
	{
	  #ifdef USE_ASSERT
	  assert (t<expiry());
	  #endif
	  PiecewiseLinear current = future_hedge;
	  current.restrict_slope (-spot.ask(), -spot.bid());
	  return current;
	};

	Portfolio payoff (const Spot& spot) const
	{
	  return _payoff(spot);
	}

	PiecewiseLinear payoff_hedge (const Spot& spot) const
	{
	  return portfolios_that_can_afford (payoff(spot), spot);
	}

private:
	PayoffBridge _payoff;
};

#endif // EUROPEAN_H
