/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef TREEPRODUCT_EUROPEAN_SELLERNOOPTIONAL_H
#define TREEPRODUCT_EUROPEAN_SELLERNOOPTIONAL_H

#include "european.h"

///Prices #TreeProductEuropean for the seller (deprecated).
/**
	Buyer must exercise.
	@author Alet Roux <alet.roux@york.ac.uk>
*/
class TreeProductEuropeanSeller : public TreeProductEuropean
{

public:
    TreeProductEuropeanSeller (const coefficient expiry, const PayoffBridge& payoff) : TreeProductEuropean(expiry, payoff) {};

    coefficient current_price(const PiecewiseLinear& current, const Portfolio& holdings = Portfolio (0,0)) const
    {
      return sellers_price (current, holdings);
    }

    PiecewiseLinear final_hedge (const Spot& spot) const
    {
        return payoff_hedge (spot);
    };

};


#endif // TREEPRODUCT_EUROPEAN_SELLERNOOPTIONAL_H
