/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef TREEPRODUCT_EUROPEAN_SELLER_H
#define TREEPRODUCT_EUROPEAN_SELLER_H

#include "europeanseller.h"

/**
 \file
Descendants of #TreeProduct appropriate for European options
 */

///Prices #TreeProductEuropean for the seller.
/**
	Allows for possibility that option may not be exercised at all, even if payoff is non-zero.
	@author Alet Roux <alet.roux@york.ac.uk>
*/
class TreeProductEuropeanSellerOptional : public TreeProductEuropeanSeller
{

public:
	TreeProductEuropeanSellerOptional (const coefficient expiry, const PayoffBridge& payoff) : TreeProductEuropeanSeller (expiry, payoff) {};

	PiecewiseLinear final_hedge (const Spot& spot) const
	{
	  PiecewiseLinear hedge = payoff_hedge (spot);
	  ensure_solvent (hedge, spot);
	  return hedge;
	};
};

#endif // TREEPRODUCT_EUROPEAN_SELLER_H
