/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef EXERCISABLE_H
#define EXERCISABLE_H

//#include "../numbers.h"
#include "../spot.h"
#include "../portfolio.h"

///Encapsulates exercise decision at a particular time and spot.
class TreeProductExercisable
{
	/**
	 * Is it optimal to exercise at this price and time?
	 * @param t Current time
	 * @param spot Price of underlying asset
	 * @param current_portfolio Current portfolio. Must correspond to a point in the epigraph of #interim_hedge(\a t, \a spot, \a future_hedge).
	 * @return \f$ 1 \f$ if exercise is optimal and \f$ 0 \f$ if it isn't
	 */
	virtual int exercise (const coefficient t, const Spot& spot, const Portfolio& current_portfolio) const = 0;
};

#endif // EXERCISABLE_H
