/*
    American option pricer under proportional transaction costs
    Copyright (C) 2011 Alet Roux alet.roux@york.ac.uk

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef RANDOMEXERCISABLE_H
#define RANDOMEXERCISABLE_H

//#include "../numbers.h"
//#include "../spot.h"
//#include "../piecewiselinear/piecewiselinear.h"
//#include "../portfolio.h"

///Encapsulates randomised exercise decision.
class TreeProductRandomExercisable
{
	/**
	 * Value of (least) optimal randomised stopping time for the buyer at time \a t with share price \a spot for the seller. The assumptions are that it has not been fully exercised yet, the current and future hedging portfolios are bounded from below by \a current_hedge and \a future_hedge, respectively, the number \a x is in the bid-ask interval, and \a shares is the current share holding. The function returns a number \f$\chi\in[0,1]\f$, and optionally numbers \a y and \a S in the bid-ask interval such that \f$x=\chi S + (1-\chi)y\f$.
	 */
	virtual coefficient random_exercise (const coefficient t, const Spot& spot, const PiecewiseLinear& current_hedge, const PiecewiseLinear& future_hedge, const coefficient x, coefficient& y, coefficient& S, const Portfolio &portfolio) const = 0;
};

#endif // RANDOMEXERCISABLE_H
