package mutation_system_for_jason;

import jason.JasonException;
import jason.environment.Environment;
import jason.infra.centralised.CentralisedEnvironment;
import jason.infra.centralised.RunCentralisedMAS;
import jason.mas2j.ClassParameters;

import java.lang.reflect.Field;

public class CustomCentralisedEnvironment extends CentralisedEnvironment {
    
    public CustomCentralisedEnvironment(ClassParameters userEnvArgs, RunCentralisedMAS masRunner) throws JasonException {
    	super(null, masRunner);
        if (userEnvArgs != null) {
            try {
        		Field fUserEnv = CentralisedEnvironment.class.getDeclaredField("userEnv");
        		fUserEnv.setAccessible(true);
        		fUserEnv.set(this, (Environment) new ClassReloader().loadClass(userEnvArgs.getClassName()).newInstance());
        		Environment userEnv = (Environment) fUserEnv.get(this);
                userEnv.setEnvironmentInfraTier(this);
                userEnv.init(userEnvArgs.getParametersArray());
            } catch (Exception e) {
                throw new JasonException("The user environment class instantiation '"+userEnvArgs+"' has failed!"+e.getMessage());
            }
        }
    }
}
