package mutation_system_for_jason;

import jason.control.ExecutionControl;

public class ExecutionController extends ExecutionControl {
	
	private boolean mutRun = false;
	private int endCycle = 1;
	
	public ExecutionController() {
		setRunningCycle(false);
	}
    
    public void run(int endCycle) {
    	this.endCycle = endCycle;
    	startMutRun();
    }
    
	private void startMutRun() {
		mutRun = true;
		startRun();
		while(mutRun) {	
			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
	
	private void startRun() {
		startCycle();
		continueRun();
	}
	
	private void startCycle() {
		super.startNewCycle();
	}
	
    private void continueRun() {
        try {
            Thread.sleep(50);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	    infraControl.informAllAgsToPerformCycle(getCycleNumber());
    }
    
    protected void allAgsFinished() {
    	if(getCycleNumber() == endCycle) {
    		setRunningCycle(false);
    		mutRun = false;
    	} else {
    		startCycle();
    		continueRun();
    	}
    }
}