package mutation_system_for_jason;

import jason.asSyntax.Literal;

import java.util.ArrayList;
import java.util.Iterator;

public class MutationDomain {
	private String agName;
	private ArrayList<Literal> beliefs = new ArrayList<Literal>();
	private ArrayList<Literal> initGoals = new ArrayList<Literal>();
	private ArrayList<String> planLabels = new ArrayList<String>();
	
	public MutationDomain(String agName) {
		this.agName = agName;
	}
	
	public String getAgName() {
		return agName;
	}
	
	public void addBel(Literal l) {
		beliefs.add(l);
	}
	
	public void addInitGoal(Literal l) {
		initGoals.add(l);
	}
	
	public void addPlan(String p) {
		planLabels.add(p);
	}
	
	public Iterator<Literal> getBels() {
		return beliefs.iterator();
	}
	
	public Iterator<Literal> getInitGoals() {
		return initGoals.iterator();
	}
	
	public Iterator<String> getPlans() {
		return planLabels.iterator();
	}
}
