package mutation_system_for_jason;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class MutationResultSheet extends JFrame {
	
	private static final long serialVersionUID = 1L;

	public MutationResultSheet(ArrayList<MutationOperator> mops, HashMap<Integer, HashMap<Integer, Boolean>> mutantNumbers) {
		String[] headers = {"Mutation Operator", "No. of Generated Mutants", 
				"No. of Killed Mutants"};
		DefaultTableModel tableModel = new DefaultTableModel(null, headers) {
			private static final long serialVersionUID = 1L;
			public boolean isCellEditable(int row, int column) {
				return false;
			}
		};
		int totalMutantNumber = 0;
		int totalKilledMutantNumber = 0;
		int size = mops.size();
		for(int i=0;i<size;i++) {
			int mutantNumber = mutantNumbers.get(i).size();
			int killedMutantNumber = getKilledMutantNumber(mutantNumbers.get(i));
			tableModel.addRow(new Object[] {mops.get(i).getName(), mutantNumber, killedMutantNumber});
			totalMutantNumber+=mutantNumber;
			totalKilledMutantNumber+=killedMutantNumber;
		}
		tableModel.addRow(new Object[]{"Total", totalMutantNumber, totalKilledMutantNumber});
		
		JTable table = new JTable(tableModel);
		TableColumn column = table.getColumnModel().getColumn(0);
		column.setPreferredWidth(250);
		column.setMaxWidth(250);
		column.setMinWidth(250);
		column = table.getColumnModel().getColumn(1);
		column.setPreferredWidth(150);
		column.setMaxWidth(150);
		column.setMinWidth(150);
		column = table.getColumnModel().getColumn(2);
		column.setPreferredWidth(150);
		column.setMaxWidth(150);
		column.setMinWidth(150);		
		JScrollPane jScrollPane = new JScrollPane(table);
		jScrollPane.setPreferredSize(new Dimension(550,250));
		jScrollPane.setMaximumSize(new Dimension(550,250));
		jScrollPane.setMinimumSize(new Dimension(550,250));
		this.getContentPane().add(jScrollPane);
		
		this.setTitle("Result of Mutation Testing");
		this.setVisible(true);
		this.pack();
		this.setResizable(false);
	}
	
	private int getKilledMutantNumber(HashMap<Integer, Boolean> mutantNumber) {
		int killedMutantNumber = 0;
		Iterator<Integer> keys = mutantNumber.keySet().iterator();
		while(keys.hasNext()) {
			if(mutantNumber.get(keys.next()))
				killedMutantNumber++;
		}
		return killedMutantNumber;
	}
}
