package mutation_system_for_jason;

import jason.asSemantics.Event;
import jason.asSyntax.Literal;
import jason.asSyntax.Plan;
import jason.asSyntax.Trigger.TEType;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class MutationSystemPane extends JPanel implements ActionListener, ListSelectionListener{
	private static final long serialVersionUID = 1L;
	
	private MutationSystem mutationSystem;
	
	private JList agentList;
	private DefaultListModel agentListModel;
	private JList belList;
	private DefaultListModel belListModel;
	private JList goalList;
	private DefaultListModel goalListModel;
	private JList planList;
	private DefaultListModel planListModel;
	private JTable mopTable;
	private DefaultTableModel mopTableModel;
	private JTextPane exeLogPanel;
	private JButton startMutButton;
	
	public MutationSystemPane(MutationSystem mutationSystem) {
		this.mutationSystem = mutationSystem;
		initComponents();
	}
	
	private void initComponents() {
		setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
		
		JLabel label = new JLabel("Step 1: Select an agent then its mutation domain. (Press Ctrl for multi-selection)");
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout(FlowLayout.LEFT));		
		panel.add(label);
		add(panel);		
		agentListModel = new DefaultListModel();
		agentList = new JList(agentListModel);
		agentList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		agentList.addListSelectionListener(this);
		JScrollPane scrollPane = new JScrollPane(agentList);
		scrollPane.setPreferredSize(new Dimension(200,250));
		JPanel list = new JPanel(new BorderLayout());
		list.add(BorderLayout.CENTER, scrollPane);
		list.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Agents", TitledBorder.LEFT, TitledBorder.TOP));		
		belListModel = new DefaultListModel();
		belList = new JList(belListModel);
		JScrollPane scrollPane2 = new JScrollPane(belList);
		scrollPane2.setPreferredSize(new Dimension(200,250));
		JPanel list2 = new JPanel(new BorderLayout());
		list2.add(BorderLayout.CENTER, scrollPane2);
		list2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Beliefs", TitledBorder.LEFT, TitledBorder.TOP));	
		goalListModel = new DefaultListModel();
		goalList = new JList(goalListModel);
		JScrollPane scrollPane3 = new JScrollPane(goalList);
		scrollPane3.setPreferredSize(new Dimension(200,250));
		JPanel list3 = new JPanel(new BorderLayout());
		list3.add(BorderLayout.CENTER, scrollPane3);
		list3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Initial Goals", TitledBorder.LEFT, TitledBorder.TOP));		
		planListModel = new DefaultListModel();
		planList = new JList(planListModel);
		JScrollPane scrollPane4 = new JScrollPane(planList);
		scrollPane4.setPreferredSize(new Dimension(200,250));
		JPanel list4 = new JPanel(new BorderLayout());
		list4.add(BorderLayout.CENTER, scrollPane4);
		list4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Plans", TitledBorder.LEFT, TitledBorder.TOP));		
		JPanel panel2 = new JPanel();
		panel2.setLayout(new FlowLayout(FlowLayout.LEFT));
		panel2.add(list);
		panel2.add(list2);
		panel2.add(list3);
		panel2.add(list4);		
		add(panel2);
		
		JLabel label2 = new JLabel("Step 2: Select the mutation operators.");
		JPanel panel3 = new JPanel();
		panel3.setLayout(new FlowLayout(FlowLayout.LEFT));		
		panel3.add(label2);
		add(panel3);
		String[] headers = {"ID", "Mutation Operator", "Scope", "If Selected"};
		mopTableModel = new DefaultTableModel(null, headers) {
			private static final long serialVersionUID = 1L;
			public Class<?> getColumnClass(int c) {
				switch(c) {
					case 3: return Boolean.class;
					default: return String.class;
				}
			}
			public boolean isCellEditable(int row, int column) {
				if((column == 0)||(column == 1)||(column == 2))
					return false;
				return true;
			}
		};
		mopTable = new JTable(mopTableModel);
		TableColumn column = mopTable.getColumnModel().getColumn(0);
		column.setPreferredWidth(50);
		column.setMaxWidth(50);
		column.setMinWidth(50);
		column = mopTable.getColumnModel().getColumn(1);
		column.setPreferredWidth(250);
		column.setMaxWidth(250);
		column.setMinWidth(250);
		column = mopTable.getColumnModel().getColumn(2);
		column.setPreferredWidth(200);
		column.setMaxWidth(200);
		column.setMinWidth(200);		
		column = mopTable.getColumnModel().getColumn(3);
		column.setPreferredWidth(100);
		column.setMaxWidth(100);
		column.setMinWidth(100);
		JScrollPane scrollPane5 = new JScrollPane(mopTable);
		scrollPane5.setPreferredSize(new Dimension(600,150));
		scrollPane5.setMaximumSize(new Dimension(600,150));
		scrollPane5.setMinimumSize(new Dimension(600,150));
		JPanel panel4 = new JPanel();
		panel4.setLayout(new FlowLayout(FlowLayout.LEFT));		
		panel4.add(scrollPane5);
		add(panel4);
		add(new JSeparator(SwingConstants.HORIZONTAL));
		
		JLabel label3 = new JLabel("Step 3:");
		startMutButton = new JButton("Start mutation");
		startMutButton.addActionListener(this);
		JPanel panel5 = new JPanel();
		panel5.setLayout(new FlowLayout(FlowLayout.LEFT));		
		panel5.add(label3);
		panel5.add(startMutButton);
		add(panel5);
		
		exeLogPanel = new JTextPane();
		exeLogPanel.setEditable(false);
		JScrollPane scrollPane6 = new JScrollPane(exeLogPanel);
		scrollPane6.setPreferredSize(new Dimension(840,100));
		JPanel list5 = new JPanel(new BorderLayout());
		list5.add(BorderLayout.CENTER, scrollPane6);
		list5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Mutation Log", TitledBorder.LEFT, TitledBorder.TOP));
		
		JPanel panel7 = new JPanel();
		panel7.setLayout(new FlowLayout(FlowLayout.LEFT));
		panel7.add(list5);
		add(panel7);
	}
	
    public void updateAgents(List<String> agNames) {
    	for (String agName: agNames) {
    		agentListModel.addElement(agName);
    	}
    }
    
    public void updateBeliefs(Iterator<Literal> beliefs) {
    	belListModel.removeAllElements();
    	while(beliefs.hasNext()) {
    		belListModel.addElement(beliefs.next());
    	}
    }
    
    public void updateInitGoals(Iterator<Event> events) {
    	goalListModel.removeAllElements();
    	while(events.hasNext()) {
    		Event event = events.next();
    		if(event.getTrigger().getType().equals(TEType.achieve)) {
    			goalListModel.addElement(TEType.achieve.toString()+event.getTrigger().getLiteral());
    		}
    	}
    }
    
    public void updatePlans(Iterator<Plan> plans) {
		planListModel.removeAllElements();
		while(plans.hasNext()) {
		    planListModel.addElement(plans.next());
		}
    }
	
    public void updateMOPs(ArrayList<MutationOperator> mops) {
    	Iterator<MutationOperator> iterator = mops.iterator();
    	while(iterator.hasNext()) {
    		MutationOperator mop = iterator.next();
    		mopTableModel.addRow(new Object[] {mop.getIndex()+1, mop.getName(), mop.getScope(), false});
    	}
    }
    
    public void log(String log) {
    	this.setDocs(log, Color.BLACK, false, 13);
    }
    
    public void logError(String log) {
    	this.setDocs(log, Color.RED, true, 13);
    }
    
    public void clearLog() {
    	exeLogPanel.setText("");
    }
	
	public void actionPerformed(ActionEvent evt) {
		JButton source = (JButton) evt.getSource();
		if(source.equals(startMutButton)) {
			MutationDomain mutD = new MutationDomain((String)agentList.getSelectedValue());
			
			Object[] beliefs = belList.getSelectedValues();
			int length = beliefs.length;
			for(int i=0;i<length;i++)
				mutD.addBel((Literal)beliefs[i]);
			
			Object[] initGoals = goalList.getSelectedValues();
			length = initGoals.length;
			for(int i=0;i<length;i++)
				mutD.addInitGoal(Literal.parseLiteral(((String)initGoals[i]).split(TEType.achieve.toString())[1]));
			
			Object[] plans = planList.getSelectedValues();
			length = plans.length;
			for(int i=0;i<length;i++)
				mutD.addPlan(((Plan)plans[i]).getLabel().getFunctor().toString());
			
			ArrayList<MutationOperator> mops = new ArrayList<MutationOperator>();
			length = mopTableModel.getRowCount();
			for(int i=0;i<length;i++)
				if((Boolean)mopTableModel.getValueAt(i, 3))
					mops.add(new MutationOperator(mopTableModel.getValueAt(i, 1).toString(), i));
			
			mutationSystem.startMutation(mutD, mops);
		}
	}
	
	public void valueChanged(ListSelectionEvent evt) {
		JList source = (JList) evt.getSource();
		if((source.equals(agentList))&&(source.getValueIsAdjusting())) {
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					mutationSystem.getSelectedAgFromInfra(agentList.getSelectedValue().toString());
				}
			});
		}
	}
	
    private void insert(String str, AttributeSet attrSet) {     
        Document doc = exeLogPanel.getDocument();     
        str =  str + "\n";     
        try {     
            doc.insertString(doc.getLength(), str, attrSet);     
        }catch(BadLocationException e) {     
            System.out.println("BadLocationException: " + e);     
        }
    }
    
    private void setDocs(String str, Color col, boolean bold, int fontSize) {     
        SimpleAttributeSet attrSet = new SimpleAttributeSet();     
        StyleConstants.setForeground(attrSet, col);        
        if(bold==true) {     
            StyleConstants.setBold(attrSet, true);     
        }  
        StyleConstants.setFontSize(attrSet, fontSize);
        insert(str, attrSet);
    }
}
