; texmenu.cmd: basic TeX commands running from a menu in MicroEMACS
; SPE 1997/08/12
; SPE 2002/10/19,24,25 Assorted me/2k/xp fixes and bodges

; run standard startup script as well

;!force execute-file emacs.rc

; get command string for start command (windows starts the appropriate 
; application based on extension, currently for PostScript viewer only).
; This seems to be the simplest way to do it!

!if &seq "" &env "comspec"
  set %TeX-start "start " ; hope for the best!
!else
  set %TeX-start &cat &env "comspec" " /c start "
!endif

; emergency override. Put set %TeX-start="whatever" in start.cmd if necessary
; (in microemacs home directory)

!force execute-file start.cmd

add-mode "WRAP"
add-global-mode "WRAP"
add-mode "white"
add-mode "BLACK"
add-global-mode "white"
add-global-mode "BLACK"

print "[Loading TeX menu]"

; extract basename of current file. Use file name not buffer name because 
; it's the file name that matters and the two can be out of phase (e.g.
; File|Rename and File|Save As both change file name but not buffer name)

store-procedure TeXmenu-get-base

  set %TeX-posn &sindex &reverse $cfname "\"
  !if &equal %TeX-posn 0
    set %TeX-file $cfname
  !else
    set %TeX-file &right $cfname &sub %TeX-posn 1
  !endif
  set %TeX-posn &sindex &reverse %TeX-file "."
  set %TeX-base &left %TeX-file &sub &len %TeX-file %TeX-posn

!endm

store-procedure TeXmenu-run-LaTeX
  save-file
  run TeXmenu-get-base
  execute-program &cat "latex " %TeX-base
!endm

store-procedure TeXmenu-run-TeX
  save-file
  run TeXmenu-get-base
  execute-program &cat "tex " %TeX-base
!endm

store-procedure TeXmenu-run-preview
  run TeXmenu-get-base
  1 execute-program &cat "dvips " %TeX-base
  execute-program &cat &cat %TeX-start %TeX-base ".ps"
!endm

store-procedure TeXmenu-run-dviview
  run TeXmenu-get-base
  execute-program &cat "yap " %TeX-base
!endm

store-procedure TeXmenu-run-preview-landscape
  run TeXmenu-get-base
  1 execute-program &cat "dvips -t landscape " %TeX-base
  execute-program &cat &cat %TeX-start %TeX-base ".ps"
!endm

store-procedure TeXmenu-run-dvips
  run TeXmenu-get-base
  execute-program &cat "dvips " %TeX-base
!endm

store-procedure TeXmenu-run-dvips-landscape
  run TeXmenu-get-base
  execute-program &cat "dvips -t landscape " %TeX-base
!endm

store-procedure TeXmenu-run-ghostview
  run TeXmenu-get-base
  execute-program &cat &cat %TeX-start %TeX-base ".ps"
!endm

store-procedure TeXmenu-run-BibTeX
  run TeXmenu-get-base
  execute-program &cat "bibtex " %TeX-base
!endm

store-procedure TeXmenu-run-makeindex
  run TeXmenu-get-base
  execute-program &cat "makeindex " %TeX-base
!endm

store-procedure TeXmenu-run-lacheck
  run TeXmenu-get-base
  execute-program &cat "c:\localtexmf\bin\lacheck " %TeX-base
!endm

store-procedure TeXmenu-make-backup

  !if &sequal "" $cfname
    print "No file name"
    !return
  !endif

  !if &exist &cat $cfname ".bak"
    print "This will overwrite the existing backup. OK to continue (y/n)? "
    !if &not &sequal "y" &lower &gtc
      print "[Backup aborted]"
      !return
    !endif
  !endif

  set %TeX-cfname $cfname
  set %TeX-cbflags $cbflags
  set $cfname &cat $cfname ".bak"  
  !force save-file
  set $cfname %TeX-cfname
  set $cbflags %TeX-cbflags

!endm

store-procedure TeXmenu-recover-backup
  !if &sequal "" $cfname
    print "No file name"
    !return
  !endif
  !if &band $cbflags 2
    print "Buffer has changed. Overwrite with backup (y/n)? "
    !if &not &sequal "y" &lower &gtc
      print "[Recovery aborted]"
      !return
    !endif
  !endif
  beginning-of-file
  set-mark
  end-of-file
  kill-region
  !force insert-file &cat $cfname ".bak"
  !if &not $status
    print "Unable to load backup file"
    yank
  !endif
  beginning-of-file
!endm

!force unbind-menu ">&TeX"
macro-to-menu TeXmenu-run-TeX ">&TeX>Save and Plain &TeX"
macro-to-menu TeXmenu-run-LaTeX "Save and &LaTeX"
bind-to-menu nop "-"
macro-to-menu TeXmenu-run-dviview "Preview D&VI"
macro-to-menu TeXmenu-run-preview "&Preview or Print"
macro-to-menu TeXmenu-run-preview-landscape "Preview or Print (landscape)"
macro-to-menu TeXmenu-run-dvips "&dvips"
macro-to-menu TeXmenu-run-dvips-landscape "dvips (landscape)"
macro-to-menu TeXmenu-run-ghostview "&Ghostview"
bind-to-menu nop "-"
macro-to-menu TeXmenu-run-BibTeX "&BibTeX"
macro-to-menu TeXmenu-run-makeindex "&makeindex"
macro-to-menu TeXmenu-run-lacheck "la&check"
bind-to-menu nop "-"
macro-to-menu TeXmenu-make-backup "Make backup"
macro-to-menu TeXmenu-recover-backup "Recover backup"


print "[Done]"
