import java.util.Collection;
import javax.sound.midi.*;

AMidiPlayer midiPlayer;
AMidiPlayer midiPlayer2;
AMidiPlayer midiPlayer3;
//PShader shader;
int fileNum = 0;
int filesLength;

String[] files ={};

String[] loadFiles(){
  //choose a random tree...
  String treeName = treeNames[int( random(0, treeNames.length-1))].toLowerCase();
  String[] f = {treeName + "_chords.mid", 
          treeName + "_keyboard.mid",
          treeName + "_french.mid"};
   filesLength = f.length;
   println("Loaded:" + filesLength);
  return f;
}

                   
void mousePressed(){
  files = loadFiles();
  String f= files[fileNum % files.length];
  println(f);
  midiPlayer.load(dataPath(f));
  midiPlayer.start();
  fileNum++;
  
}


void setup() {
  //fullScreen(P3D);
  size(1000, 752, P3D);
  files = loadFiles();
  
  ambientLight(255,0,200);

  background(0);
  colorMode(HSB);
  noStroke();
  
  
   
  midiPlayer = new AMidiPlayer();
  midiPlayer2 = new AMidiPlayer();
  midiPlayer3 = new AMidiPlayer();
  //println(files);
  midiPlayer.load(dataPath(files[0]));
  
  //midiPlayer.load(dataPath("Rhamnus frangula.mid")); 
  midiPlayer.start();

  //shader = loadShader("shader.glsl");//doesn't use
}

void draw() {
  //background(#112244);
  //shader.set("n", 20 * noise(frameCount * 0.001));

  translate(width/2, height/2);
  rotateZ(noise(0.23, 15 * frameCount * 0.00013));
  rotateY(frameCount * 0.003);

  directionalLight(30, 20, 255, 1, 1, 1);
  directionalLight(150, 20, 255, -1, -1, -1);
  
  for (Note n : midiPlayer.getNotes()) {
    fill(map(n.note % 12, 0, 11, 255, 200), 
      map(n.channel, 0, 15, 100, 200), 
      map(n.note, 0, 127, 200, 255) * random(0.5, 1.0), 150);

    pushMatrix();
      float t = frameCount * 0.003;
      scale(n.velocity * 0.05);
      rotateX(n.channel + noise(n.note * 0.1, t));
      rotateY(n.note * 0.06);
      rotateZ(map(n.note % 12, 0, 12, 0, TWO_PI));
      pushMatrix();
        translate(0, n.velocity * 0.7, 0);
        box(40.0 / n.living, n.velocity * 0.1 + random(10), 40.0 / n.living);
        sphere(40.0 / n.living);
      popMatrix();    
      translate(0, 5000.0, 0);
      box(0.2, 10000, 0.2);
    popMatrix();
  }
  midiPlayer.update();
}
