import java.util.concurrent.ConcurrentHashMap;

class AMidiPlayer implements Receiver {
  Sequencer sequencer;
  // Concurrent, so it can be accessed by the Processing main thread, and the
  // midi player thread without crashing.
  ConcurrentHashMap<Integer, Note> midiData = new ConcurrentHashMap<Integer, Note>();

  public void load(String path) {
   
    File midiFile = new File(path);
    try {
      sequencer = MidiSystem.getSequencer();
      sequencer.open();
      /*
      println( sequencer.getDeviceInfo());
      Synthesizer synth = MidiSystem.getSynthesizer();
      Sequencer player = MidiSystem.getSequencer();
      
       println("Got synth: "+synth);
       synth.loadInstrument(synth.getAvailableInstruments()[3]);
       synth.open();
       //player.setSequence(sequencer);
        player.start();
       
    try {
        Soundbank theSoundbank = synth.getDefaultSoundbank();
        println("Got soundbank: "+theSoundbank);
        synth.loadAllInstruments(theSoundbank);
        
        Instrument[] theInstruments = synth.getAvailableInstruments();
        for (Instrument i : theInstruments){
          println(i.getName());
        }
    } finally {
        //synth.close();
    }
      ////////
      */
      
      
      
      
      
      
      
      if (sequencer == null) {
        println("No midi sequencer");
        exit();
        
      } else {
        sequencer.open();
        Transmitter transmitter = sequencer.getTransmitter();
        transmitter.setReceiver(this);
        Sequence seq = MidiSystem.getSequence(midiFile);
        sequencer.setSequence(seq);
      }
    } 
    catch(Exception e) {
      e.printStackTrace();
      exit();
    }
  }

  public void start() {
    try{
    sequencer.start();
    }catch(Exception e){
      println(e);
    }
  }
  public void getNextBit(){
    if (filesLength == fileNum){
       midiPlayer.close();
       println("done");
    }else{
      midiPlayer.load(dataPath(files[fileNum% files.length]));
      midiPlayer.start();
      fileNum++;
    }
  }

  public void update() {
    
    for (Note n : midiData.values()) {
      if (n.dying > 0) {
        n.dying++;
        if (n.dying > 10) {
          int id = n.channel * 1000 + n.note;
          midiData.remove(id);
        }
      } else {
        n.living++;
      }
    }
    if ( sequencer.isRunning() == false){
        //println( sequencer.isRunning() );
        getNextBit();
    
    }
     
  }

  public float getBPM() {
    return sequencer.getTempoInBPM();
  }

  public Collection<Note> getNotes() {
    return midiData.values();
  }

  // When I say "send" I mean "receive" :)
  @Override public void send(MidiMessage message, long t) {
    if (message instanceof ShortMessage) {
      ShortMessage sm = (ShortMessage) message;
      int cmd = sm.getCommand(); 
      if (cmd == ShortMessage.NOTE_ON || cmd == ShortMessage.NOTE_OFF) {
        int channel = sm.getChannel() - 1;  
        
        int note = sm.getData1();
        int velocity = sm.getData2();
        int id = channel * 1000 + note;
        
        if (cmd == ShortMessage.NOTE_ON && velocity > 0) {
          //println( channel, note, velocity);
          
          midiData.put(id, new Note(-1, note, velocity));
        } else {
          midiData.get(id).dying++;
        }
      }
    }
  }

  @Override public void close() {
  }
}
