gnuplot << 'eof'
set term pngcairo size 500,300 enhanced
set lmargin 6.5
set bmargin 2.5
set rmargin 1.5
set tmargin 0.5


set xlabel 'Year' offset 0,0.5
set ylabel 'Error {\260}C' offset 2.0,0

set xtics 10
set mxtics 10
set mytics 2
set key at 2013,0.25 width -5 spacing 0.75 font 'Helvetica,10' maxrows 2
set style data lines

set ytics 0.1 ('' 0.2, '0.1' 0.1, '0' 0.0, '-0.1' -0.1, '' -0.2, '0.1' -0.3, '0' -0.4, '-0.1' -0.5)
set output 'gleisner_errors.png'
set key at 2013,-0.5 width -3 spacing 0.75 font 'Helvetica,10' maxrows 1
plot [1979:2013][-0.55:0.15] 'validate/merra_blend.temp' u 1:($4+0.0) title 'No fill', 'validate/merra_blend_fill.temp' u 1:($4-0.2) title 'G15 zonal', 'validate/merra_krig_blend_ice.temp' u 1:($4-0.4) title 'CW kriging', 0 ls 0 notitle, -0.2 ls 0 notitle, -0.4 ls 0 notitle, -0.6 ls 0 notitle


reset
set term pngcairo size 500,300 enhanced
set lmargin 6.5
set bmargin 2.5
set rmargin 1.5
set tmargin 0.5


set xlabel 'Latitude range -{/Symbol f} to {/Symbol f}' offset 0,0.5
set ylabel 'Temperature trend {\260}C/decade' offset 2.0,0

set xtics 10
set mxtics 2
set ytics 0.1
set mytics 2

set key bottom right reverse Left width -7 spacing 0.7 font 'Helvetica,10'
set style data lines

set output 'gleisner_fig4.png'
plot [0:90][-0.25:0.35] 'gleisner.dat' u 1:2 lc 1 title 'UAH', '' u 1:3 lc rgb '#ffaa00' title 'RSS', '' u 1:4 lc 0 title 'HadCRUT4', '' u 1:5 w lp pt 6 lc rgb '#0077ff' title 'Radio Occultation', '' u 1:6 w lp pt 6 lc 1 notitle, '' u 1:7 w lp pt 6 lc rgb '#ffaa00' notitle, '' u 1:8 w lp pt 6 lc 0 notitle, 0 ls 0 notitle

set key bottom right reverse Left width -5 spacing 0.8 font 'Helvetica,10'

set output 'gleisner_fig4_1.png'
plot [0:90][-0.25:0.35] 'gleisner.dat' u 1:4 lc 0 notitle, 'krig_blend_ice.trend' u 1:2 lc 3 title 'HadCRUT4 Kriging', 'blend_fill.trend' u 1:2 lc 0 title 'HadCRUT4 Gleisner', 'blend.trend' u 1:2 lc rgb '#ff8800' title 'HadCRUT4 Original', 0 ls 0 notitle, for [n=2:22] 'blend_fill.all.trend' u 1:(column(n)) lw 0.2 lc rgb '#999999' notitle

set output 'gleisner_fig4_2.png'
plot [0:90][-0.25:0.35] 'gleisner.dat' u 1:4 lc 0 notitle, 'krig_blend_ice.97.trend' u 1:2 lc 3 title 'HadCRUT4 Kriging', 'blend_fill.97.trend' u 1:2 lc 0 title 'HadCRUT4 Gleisner', 'blend.97.trend' u 1:2 lc rgb '#ff8800' title 'HadCRUT4 Original', 0 ls 0 notitle, for [n=2:22] 'blend_fill.all.trend' u 1:(column(n)) lw 0.2 lc rgb '#999999' notitle, 'blend_fill.9911.trend' u 1:2 w p lc 0 pt 7 ps 0.5 notitle

'eof'
