# This program reads two map series and masks the first map series with
# the second. i.e. any cell which is missing in the corresponding month
# of the second series is also set to missing in the first.
# Usage:
#  python mask.py map.dat mask.dat > new.map


import sys, math, numpy


# read a month of map data
def read_map( lines ):
  w = lines[0].split()
  month,year = sorted( [int(w[0]),int(w[1])] )
  date = year+month/12.0-1.0/24.0
  smap = [[numpy.nan for i in range(72)] for j in range(36)]
  for j in range(len(smap)):
    w = lines[j+1].split()
    for i in range(len(smap[j])):
      if not '.' in w[i]:
        t = 0.01*float(w[i])
      else:
        t = float( w[i] )
      if t > -99.0:
        smap[j][i] = t
  smap.reverse()
  return year, month, smap


# write a month of map data
def write_map( year, month, smap ):
  tmap = reversed( smap )
  lines = ["%4d %2d\n"%(year,month)]
  for row in tmap:
    s = ""
    for val in row:
      if not numpy.isnan(val):
        s += "%7.3f "%(val)
      else:
        s += "-99.9 "
    lines.append( s[:-1] + "\n" )
  return lines


# MAIN PROGRAM
# default values
datafile1 = None
datafile2 = None
if len(sys.argv) > 1:
  datafile1 = sys.argv[1]
if len(sys.argv) > 2:
  datafile2 = sys.argv[2]

# read data
nmonths = 9999
f = open( datafile1 )
lines1 = f.readlines()
f.close()
nmonths = min(nmonths,len(lines1)/37)
f = open( datafile2 )
lines2 = f.readlines()
f.close()
nmonths = min(nmonths,len(lines2)/37)

# calculate maps
maps = []
for m in range(nmonths):
  # read land data
  year1,month1,tmap1 = read_map( lines1[37*m:37*m+37] )
  year2,month2,tmap2 = read_map( lines2[37*m:37*m+37] )
  if year1 != year2 or month1 != month2:
    raise Exception( "Mismatched land and ocean files" )
  maps.append( ( year1, month1, tmap1, tmap2 ) )

for m in range(0,nmonths):
  # read land data
  year1, month1, tmap1, tmap2 = maps[m]
  print >> sys.stderr, "Processing:",year1,month1
  for i in range(36):
    for j in range(72):
      if numpy.isnan( tmap2[i][j] ):
        tmap1[i][j] = numpy.nan
  # write
  for l in write_map( year1, month1, tmap1 ):
    print l,

