/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import org.shiftone.jrat.core.HandlerFactory;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.spi.MethodHandler;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class Monitor {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$Monitor == null ? (class$org$shiftone$jrat$core$Monitor = Monitor.class$("org.shiftone.jrat.core.Monitor")) : class$org$shiftone$jrat$core$Monitor);
    private MethodKey methodKey = null;
    private MethodHandler handler = null;
    private boolean stopped = false;
    private boolean success = true;
    private Object instance = null;
    private long startTime = 0L;
    static /* synthetic */ Class class$org$shiftone$jrat$core$Monitor;

    private Monitor(String className, String methodName, String signature, Object instance) {
        this.methodKey = new MethodKey(className, methodName, signature);
        this.handler = HandlerFactory.getMethodHandler(this.methodKey);
        this.instance = instance;
    }

    private static Monitor doStart(Object instance, String methodName, String signature) {
        String className = null;
        if (instance != null) {
            className = instance.getClass().getName();
        }
        return new Monitor(className, methodName, signature, instance).start();
    }

    public static Monitor start(Object instance, String methodName, String signature) {
        return Monitor.doStart(instance, methodName, signature);
    }

    public static Monitor start(Object instance, String methodName) {
        return Monitor.doStart(instance, methodName, "(?)");
    }

    private Monitor start() {
        this.handler.onMethodStart(this.instance, null);
        this.startTime = System.currentTimeMillis();
        return this;
    }

    public void error(Object[] args, Throwable throwable) {
        this.handler.onMethodError(this.instance, args, throwable);
        this.success = false;
    }

    public void error(Throwable throwable) {
        this.error(null, throwable);
    }

    public void stop() {
        if (this.stopped) {
            throw new RuntimeException("stop() called more than once on monitor for : " + this.methodKey);
        }
        this.stopped = true;
        this.handler.onMethodFinish(this.instance, null, null, System.currentTimeMillis() - this.startTime, this.success);
    }

    protected void finalize() throws Throwable {
        MonitorNotStoppedException throwable = new MonitorNotStoppedException();
        if (!this.stopped) {
            this.error(throwable);
            this.stop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MonitorNotStoppedException
    extends JRatException {
        private MonitorNotStoppedException() {
            super("finalize() method needed to stop() monitor");
        }
    }
}

