/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import org.shiftone.jrat.core.InternalHandler;
import org.shiftone.jrat.core.spi.MethodHandlerFactory;
import org.shiftone.jrat.provider.chain.ChainFactoryBuilder;
import org.shiftone.jrat.util.ResourceUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class RootFactory {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$RootFactory == null ? (class$org$shiftone$jrat$core$RootFactory = RootFactory.class$("org.shiftone.jrat.core.RootFactory")) : class$org$shiftone$jrat$core$RootFactory);
    public static final String SYS_PROP_CONFIGURATION = "jrat.configuration";
    public static final String SYS_PROP_FACTORY = "jrat.factory";
    static /* synthetic */ Class class$org$shiftone$jrat$core$RootFactory;

    public MethodHandlerFactory getHandlerFactory() {
        long start = System.currentTimeMillis();
        MethodHandlerFactory factory = null;
        String jratFactoryName = System.getProperty(SYS_PROP_FACTORY);
        String jratConfigName = System.getProperty(SYS_PROP_CONFIGURATION);
        LOG.info("JRat creating root handler factory...");
        LOG.info("jrat.factory = " + jratFactoryName);
        LOG.info("jrat.configuration = " + jratConfigName);
        try {
            if (jratFactoryName != null) {
                LOG.debug("jrat.factory = " + jratFactoryName);
                if (jratConfigName != null) {
                    LOG.warn("system property 'jrat.configuration' will be ignored, property '' takes precedence");
                }
                factory = (MethodHandlerFactory)ResourceUtil.newInstance(jratFactoryName);
            } else if (jratConfigName != null) {
                factory = ChainFactoryBuilder.buildFactory(jratConfigName);
            }
            LOG.info("JRat handler(s) created in " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Exception e) {
            LOG.error("error configuring JRat", e);
        }
        if (factory == null) {
            LOG.info("reverting to silent handler");
            return InternalHandler.DEFAULT_HANDLER_FACTORY;
        }
        return factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

