/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class BcelUtil {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$inject$BcelUtil == null ? (class$org$shiftone$jrat$inject$BcelUtil = BcelUtil.class$("org.shiftone.jrat.inject.BcelUtil")) : class$org$shiftone$jrat$inject$BcelUtil);
    private static final Comparator FIELD_OR_METHOD_COMPARATOR = new FieldOrMethodComparator();
    static /* synthetic */ Class class$org$shiftone$jrat$inject$BcelUtil;

    public static long computeSerialVersionUID(JavaClass javaClass) {
        try {
            int mods;
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            Method[] methods = javaClass.getMethods();
            Field[] fields = javaClass.getFields();
            dout.writeUTF(javaClass.getClassName());
            int classMods = javaClass.getAccessFlags();
            if (((classMods &= 0x611) & 0x200) != 0) {
                classMods = methods.length > 0 ? classMods | 0x400 : classMods & 0xFFFFFBFF;
            }
            dout.writeInt(classMods);
            Object[] ifaceNames = javaClass.getInterfaceNames();
            Arrays.sort(ifaceNames);
            for (int i2 = 0; i2 < ifaceNames.length; ++i2) {
                dout.writeUTF((String)ifaceNames[i2]);
            }
            Arrays.sort(fields, FIELD_OR_METHOD_COMPARATOR);
            for (i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                mods = fields[i].getAccessFlags();
                if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
                dout.writeUTF(field.getName());
                dout.writeInt(mods);
                dout.writeUTF(field.getSignature());
            }
            Arrays.sort(methods, FIELD_OR_METHOD_COMPARATOR);
            for (i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                mods = method.getAccessFlags();
                if ((mods & 2) != 0) continue;
                dout.writeUTF(method.getName());
                dout.writeInt(mods);
                dout.writeUTF(method.getSignature().replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i3 = Math.min(hashBytes.length, 8) - 1; i3 >= 0; --i3) {
                hash = hash << 8 | (long)(hashBytes[i3] & 0xFF);
            }
            return hash;
        }
        catch (IOException ex) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }

    public static boolean isSynthetic(FieldOrMethod fieldOrMethod) {
        Attribute[] attributes = fieldOrMethod.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!(attributes[i] instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FieldOrMethodComparator
    implements Comparator {
        FieldOrMethodComparator() {
        }

        public int compare(Object o1, Object o2) {
            FieldOrMethod fom1 = (FieldOrMethod)o1;
            FieldOrMethod fom2 = (FieldOrMethod)o2;
            int comp = fom1.getName().compareTo(fom2.getName());
            if (comp == 0) {
                comp = fom1.getSignature().compareTo(fom2.getSignature());
            }
            return comp;
        }
    }
}

